<?php include 'includes/header.php'; 

if (file_exists('mensagem.txt')) {
    $data = json_decode(file_get_contents('mensagem.txt'), true);
    $mensagem = htmlspecialchars($data['mensagem']);
    $cor = htmlspecialchars($data['cor']);
    $bgcolor = htmlspecialchars($data['bgcolor']);
    $opacity = htmlspecialchars($data['opacity']);
} else {
    $mensagem = "Nenhuma mensagem gravada.";
    $cor = "#000000";
    $bgcolor = "#ffffff";
    $opacity = "1";
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <style>
        .color-picker {
            margin-top: 10px;
        }

        iframe {
            width: 100%;
            height: 30px;
            border: 1px solid #ccc;
            border-radius: 10px;
            background-color: transparent;
        }
    </style>
    <script>
        function updatePreview() {
            const mensagem = document.getElementById('mensagem').value;
            const cor = document.getElementById('cor').value;
            const bgColor = document.getElementById('bgcolor').value;
            const opacity = document.getElementById('opacity').value;
            const iframe = document.getElementById('preview');

            const url = `api/msgads.php?mensagem=${encodeURIComponent(mensagem)}&cor=${encodeURIComponent(cor)}&bgColor=${encodeURIComponent(bgColor)}&opacity=${encodeURIComponent(opacity)}`;
            iframe.src = url;
        }
    </script>
</head>
<body>
    <div class="col-md-6 mx-auto">
        <div class="card-body">
            <div class="card bg-primary text-white">
                <div class="card-header card-header-warning">
                    <center>
                        <h2> MENSAGEM</h2>
                    </center>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <h5><i class="icon icon-user"></i> ENVIAR MENSAGEM</h5>
                    </div>
                    <br>
                    <form action="salvar_mensagem.php" method="post">
                        <div>
                            <label for="mensagem" style="font-weight: bold;">SUA MENSAGEM:</label>
                            <input class="form-control" type="text" id="mensagem" name="mensagem" value="<?php echo $mensagem; ?>" required>
                        </div>
                        <br>
                        <div>
                            <label for="cor" style="font-weight: bold;">COR DO TEXTO :</label>
                            <input type="color" id="cor" name="cor" value="<?php echo $cor; ?>" required><br>

                            <label style="font-weight: bold;" for="bgcolor">COR DE FUNDO:</label>
                            <input type="color" id="bgcolor" name="bgcolor" value="<?php echo $bgcolor; ?>" required><br>

                            <label style="font-weight: bold;" for="opacity">OPACIDADE:</label>
                            <input type="range" id="opacity" name="opacity" min="0" max="1" step="0.1" value="<?php echo $opacity; ?>" required><br>

                            <button class="btn btn-info" type="submit">ENVIAR</button>
                        </div>
                    </form>
                </div>
                <br>
                <center><h5 class="card-title">MENSAGEM A SER EXIBIDA:</h5><i class="fa-regular fa-hand-point-down"></i></center>
                <iframe id="preview" src="api/msg.php"></iframe>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
</body>
</html>
