<?php
if (file_exists('../mensagem.txt')) {
    $data = json_decode(file_get_contents('../mensagem.txt'), true);
    $mensagem = htmlspecialchars($data['mensagem']);
    $cor = htmlspecialchars($data['cor']);
    $bgcolor = htmlspecialchars($data['bgcolor']);
    $opacity = htmlspecialchars($data['opacity']);
} else {
    $mensagem = "Nenhuma mensagem gravada.";
    $cor = "#000000";
    $bgcolor = "#ffffff";
    $opacity = "1";
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <style>
        body {  
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
        }
        .mensagem-container {
            width: contain;
            overflow: hidden;
            white-space: nowrap;
        }
        .mensagem {
            color: <?php echo $cor; ?>;
            background-color: rgba(<?php echo hexToRgb($bgcolor); ?>, <?php echo $opacity; ?>);
            letter-spacing: 1px;
            text-transform: uppercase;
            font-size: 15px;
            font-weight: bold;
            border-radius: 5px;
            display: inline-block;
        }
        @keyframes scroll {
            0% {
                transform: translateX(30%);
            }
            100% {
                transform: translateX(-100%);
            }
        }
        .mensagem-scroll {
            animation: scroll 25s linear infinite;
        }
    </style>
    <script>
        window.addEventListener('DOMContentLoaded', function() {
            var mensagem = document.querySelector('.mensagem');
            var container = document.querySelector('.mensagem-container');
            if (mensagem.scrollWidth > container.clientWidth) {
                mensagem.classList.add('mensagem-scroll');
            }
        });

        window.addEventListener('resize', function() {
            var mensagem = document.querySelector('.mensagem');
            var container = document.querySelector('.mensagem-container');
            if (mensagem.scrollWidth > container.clientWidth) {
                mensagem.classList.add('mensagem-scroll');
            } else {
                mensagem.classList.remove('mensagem-scroll');
            }
        });
    </script>
</head>
<body>
    <div class="mensagem-container">
        <div class="mensagem">&nbsp;&nbsp;<?php echo $mensagem; ?>&nbsp;&nbsp;</div>
    </div>
</body>
</html>

<?php
function hexToRgb($hex) {
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 6) {
        list($r, $g, $b) = str_split($hex, 2);
    } elseif (strlen($hex) == 3) {
        list($r, $g, $b) = str_split($hex, 1);
        $r = $r . $r;
        $g = $g . $g;
        $b = $b . $b;
    } else {
        return '0,0,0'; 
    }
    return hexdec($r) . ',' . hexdec($g) . ',' . hexdec($b);
}
?>
